/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.railwayteam.railways.content.fuel.LiquidFuelType;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquidFuelManager {
    private static final Map<class_2960, LiquidFuelType> CUSTOM_TYPE_MAP = new HashMap<class_2960, LiquidFuelType>();
    private static final Map<class_3611, LiquidFuelType> FLUID_TO_TYPE_MAP = new IdentityHashMap<class_3611, LiquidFuelType>();
    private static final Map<class_6862<class_3611>, LiquidFuelType> TAG_TO_TYPE_MAP = new IdentityHashMap<class_6862<class_3611>, LiquidFuelType>();

    public static void clear() {
        CUSTOM_TYPE_MAP.clear();
        FLUID_TO_TYPE_MAP.clear();
        TAG_TO_TYPE_MAP.clear();
    }

    public static LiquidFuelType getTypeForFluid(class_3611 fluid) {
        return FLUID_TO_TYPE_MAP.get(fluid);
    }

    @Nullable
    public static LiquidFuelType isInTag(class_3611 fluid) {
        for (Map.Entry<class_6862<class_3611>, LiquidFuelType> entry : TAG_TO_TYPE_MAP.entrySet()) {
            if (!fluid.method_15785().method_15767(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void fillFluidMap() {
        for (Map.Entry<class_2960, LiquidFuelType> entry : CUSTOM_TYPE_MAP.entrySet()) {
            LiquidFuelType type = entry.getValue();
            for (Supplier<class_3611> supplier : type.getFluids()) {
                FLUID_TO_TYPE_MAP.put(supplier.get(), type);
            }
            for (Supplier<class_3611> supplier : type.getFluidTags()) {
                TAG_TO_TYPE_MAP.put((class_6862<class_3611>)((class_6862)supplier.get()), type);
            }
        }
    }

    public static class ReloadListener
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();
        public static final String ID = "railways_liquid_fuel";

        protected ReloadListener() {
            super(GSON, ID);
        }

        protected void apply(@NotNull Map<class_2960, JsonElement> map, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
            LiquidFuelManager.clear();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                class_2960 id = entry.getKey();
                JsonObject object = element.getAsJsonObject();
                LiquidFuelType type = LiquidFuelType.fromJson(object);
                if (type == null) continue;
                CUSTOM_TYPE_MAP.put(id, type);
            }
            LiquidFuelManager.fillFluidMap();
        }
    }
}

